/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.itr.validators;

import com.itd.efiling.itr.validation.helpers.Validator;
import com.itd.efiling.itr.validation.helpers.a;
import com.itd.efiling.itr.validators.ValidatorInteface;
import java.math.BigInteger;

public class BigIntegerValidator
extends ValidatorInteface {
    private static final BigInteger MIN_AMOUNT = BigInteger.ZERO;
    private static final BigInteger MAX_AMOUNT = BigInteger.valueOf(99999999999999999L);
    private String conAttributeName;
    private String conAttributeValue;
    private BigInteger minValue;
    private BigInteger maxValue;
    private Boolean mandatory;

    @Override
    public void validate(String string, String string2, Validator validator) {
        BigInteger bigInteger = null;
        if (string != null && string.trim().length() != 0) {
            try {
                bigInteger = new BigInteger(string);
            }
            catch (Exception exception) {
                String string3 = this.getErrorCode();
                this.setErrorCode("error.number.invalid");
                this.addFieldError(string2, validator);
                this.setErrorCode(string3);
                return;
            }
        }
        String string4 = validator.getFormValue(this.conAttributeName, string2);
        if (this.mandatory == null) {
            this.mandatory = false;
        }
        BigInteger bigInteger2 = MIN_AMOUNT;
        if (this.minValue != null) {
            bigInteger2 = this.minValue;
        }
        BigInteger bigInteger3 = MAX_AMOUNT;
        if (this.maxValue != null) {
            bigInteger3 = this.maxValue;
        }
        if (!a.a(string4) && string4.equals(this.conAttributeValue)) {
            if (bigInteger == null) {
                this.addFieldError(string2, validator);
            } else if (bigInteger.compareTo(bigInteger2) < 0 || bigInteger.compareTo(bigInteger3) > 0) {
                this.addFieldError(string2, validator);
            }
        } else if (bigInteger != null && (bigInteger.compareTo(bigInteger2) < 0 || bigInteger.compareTo(bigInteger3) > 0)) {
            this.addFieldError(string2, validator);
        }
    }

    public String getConAttributeName() {
        return this.conAttributeName;
    }

    public void setConAttributeName(String string) {
        this.conAttributeName = string;
    }

    public String getConAttributeValue() {
        return this.conAttributeValue;
    }

    public void setConAttributeValue(String string) {
        this.conAttributeValue = string;
    }

    public BigInteger getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigInteger bigInteger) {
        this.minValue = bigInteger;
    }

    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigInteger bigInteger) {
        this.maxValue = bigInteger;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean bl) {
        this.mandatory = bl;
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new BigIntegerValidator();
    }
}

